/////////////////////////////////////////////////////////////
// CINEMA SDK : CINEMA OPERATING SYSTEM        						 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// Interface Functions

#ifndef __GEPREPASS_H
#define __GEPREPASS_H

#include "ge_math.h"

// HyperFile::GetError
#define FILEERROR_NONE    	           0 // no error
#define FILEERROR_OPEN							  -1 // problems opening the file
#define FILEERROR_CLOSE								-2 // problems closing the file
#define FILEERROR_READ   							-3 // problems reading the file
#define FILEERROR_WRITE								-4 // problems writing the file
#define FILEERROR_SEEK								-5 // problems seeking the file
#define FILEERROR_INVALID							-6 // invalid parameter or operation (e.g. writing in read-mode)
#define FILEERROR_MEMORY							-7 // not enough memory
#define FILEERROR_WRONG_VALUE       -100 // other value detected than expected
#define FILEERROR_CHUNK_NUMBER      -102 // wrong number of chunks or sub chunks detected
#define FILEERROR_VALUE_NO_CHUNK    -103 // there was a value without any enclosing START/STOP chunks
#define FILEERROR_FILE_END          -104 // the file end was reached without finishing reading
#define FILEERROR_UNKNOWN_VALUE     -105 // unknown value detected

// BaseFile::Open
#define GE_READ		1
#define GE_WRITE	2
#define GE_APPEND	0

#define FILE_NODIALOG		0
#define FILE_DIALOG			1
#define FILE_IGNOREOPEN	2

#define MACTYPE_CINEMA		'C4DC'
#define MACCREATOR_CINEMA	'C4D1'

// BaseFile::Seek
#define GE_START		0
#define GE_RELATIVE	2

// BaseFile::Filer
#define GE_SAVE				1
#define GE_DIRECTORY	2

// BaseBitmap::Init
#define IMAGE_OK					 1
#define IMAGE_NOTEXISTING	-1
#define IMAGE_WRONGTYPE 	-2
#define IMAGE_NOMEM				-3
#define IMAGE_DISKERROR	  -4
#define IMAGE_FILESTRUCT	-5

// BaseBitmap::Save
#define FILTER_TIF								1100
#define FILTER_TGA								1101
#define FILTER_BMP								1102
#define FILTER_IFF								1103
#define FILTER_JPG								1104
#define FILTER_PICT								1105
#define FILTER_PSD								1106
#define FILTER_RLA								1107
#define FILTER_RPF								1108
#define FILTER_B3D								1109
#define FILTER_AVI_SMALL					1120
#define FILTER_AVI_BIG						1121
#define FILTER_AVI_USER						1122
#define FILTER_MOVIE_SMALL				1123
#define FILTER_MOVIE_BIG					1124
#define FILTER_MOVIE_USER					1125
#define FILTER_QTVRSAVER_PANORAMA	1150
#define FILTER_QTVRSAVER_OBJECT		1151

#define AVISAVER_FCCTYPE					10000
#define AVISAVER_FCCHANDLER				10001
#define AVISAVER_LKEY							10002
#define AVISAVER_LDATARATE				10003
#define AVISAVER_LQ								10004

#define QTSAVER_COMPRESSOR				10010
#define QTSAVER_QUALITY						10011
#define QTSAVER_TEMPQUAL					10012
#define QTSAVER_FRAMERATE					10013
#define QTSAVER_KEYFRAMES					10014
#define QTSAVER_PLANES						10015
#define QTSAVER_DATARATE					10016
#define QTSAVER_FRAMEDURATION			10017
#define QTSAVER_MINQUALITY				10018
#define QTSAVER_MINTEMPQUAL				10019
#define QTSAVER_FIXEDFRAMERATE		10020

#define JPGSAVER_QUALITY					10021
#define IMAGESAVER_DPI						10022
#define JPGSAVER_GREYSCALE				10023
#define RLA_OPTIONS								10024

#define RLA_Z											(1<<0)
#define RLA_OBJECTBUFFER					(1<<2)
#define RLA_UV										(1<<3)
#define RLA_NORMAL								(1<<4)
#define RLA_ORIGCOLOR							(1<<5)
#define RLA_COVERAGE							(1<<6)
#define RLA_OBJECTID							(1<<8)
#define RLA_COLOR									(1<<9)
#define RLA_TRANSPARENCY					(1<<10)
#define RLA_SUBPIXEL_WEIGHT				(1<<12)
#define RLA_SUBPIXEL_MASK					(1<<13)

// savebits
#define SAVEBIT_ALPHA             (1<<0)
#define SAVEBIT_GREYSCALE         (1<<4)

// GeGetCurrentOS
#define GE_WIN										1
#define GE_MAC										2

// GeGetByteOrder
#define GE_MOTOROLA								1
#define GE_INTEL									2

// GeOutString
#define GEMB_OK										0x0000
#define GEMB_OKCANCEL							0x0001
#define GEMB_ABORTRETRYIGNORE			0x0002
#define GEMB_YESNOCANCEL					0x0003
#define GEMB_YESNO								0x0004
#define GEMB_RETRYCANCEL					0x0005

#define GEMB_ICONSTOP							0x0010
#define GEMB_ICONQUESTION					0x0020
#define GEMB_ICONEXCLAMATION			0x0030
#define GEMB_ICONASTERISK					0x0040

#define GEMB_R_OK									1
#define GEMB_R_CANCEL							2
#define	GEMB_R_ABORT							3
#define GEMB_R_RETRY							4
#define GEMB_R_IGNORE							5
#define GEMB_R_YES								6
#define GEMB_R_NO									7

// result code for mousedrag...
#define MOUSEDRAG_ESCAPE						(1)
#define MOUSEDRAG_FINISHED					(2)
#define MOUSEDRAG_CONTINUE					(3)

// flags for mousedrag...
#define MOUSEDRAG_DONTHIDEMOUSE			(1<<0)				// mousepointer should be visible
#define MOUSEDRAG_NOMOVE						(1<<1)				// mousedrag returns if no mousemove was done
#define MOUSEDRAG_EVERYPACKET				(1<<2)				// receive every packet of the queue, otherwise only data of the last packet

// BaseChannel::InitTexture
#define LOAD_OK            0
#define LOAD_NOMEM			-100
#define LOAD_NOTFOUND   -101
#define LOAD_UNKNOWN    -102
#define LOAD_DOUBLENAME	-105

// hyperfile values
#define HFILE_START   	 1
#define HFILE_STOP 		   2
#define HFILE_CSTOP      3
#define HFILE_CHAR			11
#define HFILE_UCHAR			12
#define HFILE_WORD			13
#define HFILE_UWORD			14
#define HFILE_LONG			15
#define HFILE_ULONG			16
#define HFILE_LLONG			17
#define HFILE_LULONG		18
#define HFILE_REAL			19
#define HFILE_LREAL			20
#define HFILE_BOOL			21
#define HFILE_TIME			22
#define HFILE_VECTOR		23
#define HFILE_LVECTOR		24
#define HFILE_MATRIX		25
#define HFILE_LMATRIX		26

// spline type
#define Tlinear		0
#define Tcubic		1
#define Takima		2
#define Tbspline	3
#define Thermite	4

// spline interpolation
#define Inone			0
#define Inatural	1
#define Iuniform	2
#define Iadaptive	3

// particle bits
#define PARTICLE_VISIBLE	(1<<0)
#define PARTICLE_ALIVE		(1<<1)

///////////////////bits/////////////////////

// baselist bits
#define BIT_ACTIVE					(1<<1) // active element
#define BIT_AAMAN						(1<<4) // active object in timeline
#define BIT_AFOLD						(1<<7) // folded in timeline

// materials
#define BIT_MATMARK					(1<<2) // marked material
#define BIT_ENABLEPAINT			(1<<3) // enable painting
#define BIT_MFOLD						(1<<6) // folded in material manager
#define BIT_BP_FOLDLAYERS		(1<<9) // fold layers in materialmanger

// objects
#define BIT_IGNOREDRAW			(1<<2) // ignore object during draw
#define BIT_OFOLD						(1<<6) // folded in object manager
#define BIT_CONTROLOBJECT		(1<<9) // control object

// tracks
#define BIT_ANIM_OFF 				(1<<17) // is sequence inactive

// videopost
#define BIT_VPDISABLED			(1<<2) // videopost effect is disabled

// document
#define BIT_DOCUMENT_CHECKREWIND	(1<<2)	// doc needs to check for a rewind

// object info
#define OBJECT_MODIFIER						(1<<0)
#define OBJECT_HIERARCHYMODIFIER	(1<<1)
#define OBJECT_GENERATOR					(1<<2)
#define OBJECT_INPUT							(1<<3)
#define OBJECT_PARTICLEMODIFIER		(1<<5)
#define OBJECT_NOCACHESUB					(1<<6)
#define OBJECT_SPLINE							(1<<7)
#define OBJECT_UNIQUEENUMERATION  (1<<8)

// animation info
#define ANIMINFO_QUICK						(1<<0)

// material groups
#define MATERIALGROUP_ID				100
#define MATERIALGROUP_NAME			101
#define MATERIALGROUP_SELECTED	102

///////////////////ID's/////////////////////

// list elements
#define Tbaselist2d											110050
#define Tbaselist4d											110051

// materials
#define Mbase														5702
#define Mmaterial												5703
#define Mplugin													5705
#define Mfog														8803
#define Mterrain												8808

// objects
#define Opolygon												5100
#define Ospline													5101
#define Olight													5102
#define Ocamera													5103
#define Ofloor													5104
#define Osky														5105
#define Oenvironment										5106
#define Oloft														5107
#define Offd														5108
#define Oparticle												5109
#define Odeflector											5110
#define Ogravitation										5111
#define Orotation												5112
#define Owind														5113
#define Ofriction												5114
#define Oturbulence											5115
#define Oextrude												5116
#define Olathe													5117
#define Osweep													5118
#define Oattractor											5119
#define Obezier													5120
#define Oforeground											5121
#define Obackground											5122
#define Obone														5123
#define Odestructor											5124
#define Ometaball												5125
#define Oinstance												5126
#define Ohypernurbs											5127
#define Obend														5128
#define Obulge													5129
#define Oshear													5131
#define Otaper													5133
#define Otwist													5134
#define Owave														5135
#define Ostage													5136
#define Oline														5137
#define Omicrophone											5138
#define Oloudspeaker										5139
#define Onull														5140
#define Osymmetry												5142
#define Owrap														5143
#define Oboole													5144
#define Oexplosion											5145
#define Oformula												5146
#define Omelt														5147
#define Oshatter												5148
#define Owinddeform											5149
#define Oarray													5150
#define Oheadphone											5151
#define Oconplane												5153
#define Oplugin													5154
#define Obase														5155
#define Opoint													5156
#define Obasedeform											5157
#define Opolyreduction									1001253

// primitive objects
#define Ocube														5159
#define Osphere													5160
#define Oplatonic												5161
#define Ocone														5162
#define Otorus													5163	
#define Odisc														5164
#define Otube														5165
#define Ofigure													5166
#define Opyramid												5167
#define Oplane													5168
#define Ofractal												5169
#define Ocylinder												5170 
#define Ocapsule												5171 
#define Ooiltank												5172 
#define Orelief													5173
#define Osinglepoly											5174

// spline primitive objects
#define Osplineprofile									5175
#define Osplineflower										5176
#define Osplineformula									5177
#define Osplinetext											5178
#define Osplinenside										5179
#define Ospline4side										5180
#define Osplinecircle										5181
#define Osplinearc											5182
#define Osplinecissoid									5183
#define Osplinecycloid									5184
#define Osplinehelix										5185
#define Osplinerectangle								5186
#define Osplinestar											5187
#define Osplinecogwheel									5188
#define Osplinecontour									5189

#define Oselection											5190
#define Osds												 1007455
#define Osplinedeformer							 1008982
#define Osplinerail									 1008796
#define Oatomarray									 1001002
#define Ospherify										 1001003
#define Oexplosionfx								 1002603

// small listnode plugin
#define Yplugin												110061

// big listnode plugin
#define Zplugin												110062

// shader plugins
#define Xbase														5707
#define Xcolor													5832
#define Xbitmap													5833
#define Xbrick													5804
#define Xcheckerboard										5800
#define Xcloud													5802
#define Xcolorstripes										5822
#define Xcyclone												5821
#define Xearth													5825
#define Xfire														5803
#define Xflame													5817
#define Xgalaxy													5813
#define Xgradient												5814
#define Xmetal													5827
#define Xnoise													5807
#define Xrust														5828
#define Xstar														5816
#define Xstarfield											5808
#define Xsunburst												5820
#define Xturbulence											5806
#define Xvenus													5826
#define Xwater													5818
#define Xwood														5823
#define Xplanet													5829
#define Xmarble													5830
#define Xspectral												5831

// tags
#define Tpoint													5600
#define	Tanchor													5608
#define	Tphong													5612
#define	Tdisplay												5613
#define	Tkinematic											5614
#define	Ttexture												5616
#define	Thermite2d											5617
#define	Tprotection											5629
#define	Tparticle												5630 
#define	Tmotionblur											5636
#define	Tcompositing										5637
#define	Twww														5647 
#define	Tsavetemp												5650 
#define Tpolygon												5604 
#define	Tuvw														5671
#define	Tsegment												5672
#define	Tpolygonselection								5673
#define	Tpointselection									5674
#define Tcoffeeexpression								5675
#define	Ttargetexpression								5676
#define	Tfixexpression									5677
#define	Tsunexpression									5678
#define	Tikexpression										5679
#define Tline														5680
#define Tvertexmap											5682
#define Trestriction										5683
#define	Tmetaball												5684
#define	Tbakeparticle										5685
#define Tmorph													5689
#define Tsticktexture										5690
#define	Tplugin 												5691
#define	Tstop														5693 
#define Tbase														5694 
#define Tvariable												5695 
#define Tvibrate												5698
#define Taligntospline									5699
#define Taligntopath										5700
#define	Tedgeselection									5701
#define Tclaudebonet										5708
#define Tnormal													5711
#define Tcorner													5712
#define Tsds														1007579
#define Tlookatcamera										1001001
#define Texpresso												1001149

// keys, sequences, tracks
#define Smorph													5210
#define Spla														5214
#define Smarker													5215
#define Ssound													5217
#define Splugin													5221
#define Sbase														5222
#define Svalue													5224
#define Sdata														5225
#define Sp2p														5226
#define Smomix  												5227

#define KEbase													5522
#define SEbase													5422
#define TEbase													5322

#define GVbase													1001101

// modeling commands
#define MCOMMAND_SPLINE_HARDINTERPOLATION			100
#define MCOMMAND_SPLINE_SOFTINTERPOLATION			101
#define MCOMMAND_SPLINE_REORDER								102
#define MCOMMAND_SPLINE_REVERSE								103
#define MCOMMAND_SPLINE_MOVEDOWN							104
#define MCOMMAND_SPLINE_MOVEUP								105
#define MCOMMAND_SPLINE_CHAMFER								106
#define MCOMMAND_SPLINE_ROUND									107
#define MCOMMAND_SPLINE_JOINSEGMENT						109
#define MCOMMAND_SPLINE_BREAKSEGMENT					110
#define MCOMMAND_SPLINE_EQUALLENGTH						111
#define MCOMMAND_SPLINE_EQUALDIRECTION				112
#define MCOMMAND_SPLINE_LINEUP								113
#define MCOMMAND_SPLINE_CREATEOUTLINE					114
#define MCOMMAND_SPLINE_PROJECT								115
#define MCOMMAND_SPLINE_ADDPOINT							116
#define MCOMMAND_SELECTALL										200
#define MCOMMAND_DESELECTALL									201
#define MCOMMAND_SELECTINVERSE								202
#define MCOMMAND_SELECTCONNECTED							203
#define MCOMMAND_SELECTGROW										204
#define MCOMMAND_SELECTSHRINK									205
#define MCOMMAND_SELECTPOINTTOPOLY						206
#define MCOMMAND_SELECTPOLYTOPOINT						207
#define MCOMMAND_SELECTADJACENT								208
#define MCOMMAND_GENERATESELECTION						209
#define MCOMMAND_HIDESELECTED									211
#define MCOMMAND_HIDEUNSELECTED								212
#define MCOMMAND_HIDEINVERT										213
#define MCOMMAND_UNHIDE												214
#define MCOMMAND_QUANTIZE											216
#define MCOMMAND_REVERSENORMALS								217
#define MCOMMAND_ALIGNNORMALS									218
#define MCOMMAND_SETVALUE											219
#define MCOMMAND_SPLIT												220
#define MCOMMAND_TRIANGULATE									221
#define MCOMMAND_UNTRIANGULATE								222
#define MCOMMAND_DELETE												224
#define MCOMMAND_CRUMPLE											225
#define MCOMMAND_WELD													226
#define MCOMMAND_OPTIMIZE											227
#define MCOMMAND_DISCONNECT										228
#define MCOMMAND_CREATEPOLYGON								229
#define MCOMMAND_MAKEEDITABLE									230
#define MCOMMAND_SMOOTHSHIFT									231
#define MCOMMAND_EXTRUDE											232
#define MCOMMAND_EXTRUDEINNER									233
#define MCOMMAND_BEVEL												234
#define MCOMMAND_ARRAY												235
#define MCOMMAND_CLONE												236
#define MCOMMAND_MIRROR												237
#define MCOMMAND_MATRIXEXTRUDE								238
#define MCOMMAND_NORMALMOVE										239
#define MCOMMAND_NORMALSCALE									240
#define MCOMMAND_NORMALROTATE									241
#define MCOMMAND_SUBDIVIDE										242
#define MCOMMAND_EXPLODESEGMENTS							243
#define MCOMMAND_KNIFE												244
#define MCOMMAND_CURRENTSTATETOOBJECT					245
#define MCOMMAND_JOIN													246
#define MCOMMAND_CONVERTSELECTION							247
#define MCOMMAND_EDGE_RING                    248
#define MCOMMAND_EDGE_LOOP                    249
#define MCOMMAND_EDGE_CUT                     250
#define MCOMMAND_EDGE_TO_SPLINE               251
#define MCOMMAND_EDGE_MELT                    252
#define MCOMMAND_EDGE_BEVEL                   253
#define MCOMMAND_EDGE_EXTRUDE                 254
#define MCOMMAND_BREAKPHONG										255
#define MCOMMAND_UNBREAKPHONG									256
#define MCOMMAND_PHONGTOSELECTION							257
#define MCOMMAND_EDGE_FILLSELECTION						258

// tool settings for selection commands
#define	MDATA_QUANTIZE_ENABLEX								2003 // BOOL
#define	MDATA_QUANTIZE_ENABLEY								2004 // BOOL
#define	MDATA_QUANTIZE_ENABLEZ								2005 // BOOL
#define	MDATA_QUANTIZE_VAL										2006 // VECTOR
#define	MDATA_SETVALUE_SETX										2008 // BOOL
#define	MDATA_SETVALUE_SETY										2009 // BOOL
#define	MDATA_SETVALUE_SETZ										2010 // BOOL
#define	MDATA_SETVALUE_VAL										2011 // VECTOR
#define	MDATA_SETVALUE_SYSTEM									2012 // LONG
#define MDATA_SPLINE_ROUNDPOINTS							2015 // LONG
#define MDATA_SPLINE_ROUNDTYPE								2016 // LONG
#define MDATA_SPLINE_CHAMFERFLAT							2017 // BOOL
#define MDATA_SPLINE_CHAMFERRADIUS						2018 // REAL
#define MDATA_SPLINE_FREEHANDTOLERANCE				2020 // REAL
#define MDATA_SPLINE_OUTLINE									2021 // REAL
#define MDATA_SPLINE_PROJECTMODE							2022 // LONG
#define MDATA_SPLINE_ADDPOINTSEGMENT					2023 // LONG
#define MDATA_SPLINE_ADDPOINTPOSITION					2024 // REAL
#define MDATA_CRUMPLE_MODE										2025 // LONG
#define MDATA_CRUMPLE_INANDOUT								2026 // BOOL
#define MDATA_CRUMPLE_VAL											2027 // VECTOR
#define MDATA_DISCONNECT_PRESERVEGROUPS				2028 // BOOL
#define	MDATA_SMOOTHSHIFT_ANGLE								2030 // REAL
#define	MDATA_SMOOTHSHIFT_OFFSET							2031 // REAL
#define MDATA_EXTRUDE_PRESERVEGROUPS					2032 //	BOOL
#define MDATA_EXTRUDE_OFFSET									2033 // REAL
#define	MDATA_EXTRUDE_ANGLE										2034 // REAL
#define	MDATA_EXTRUDE_VARIANCE								2035 // REAL
#define MDATA_EXTRUDEINNER_PRESERVEGROUPS			2036 //	BOOL
#define MDATA_EXTRUDEINNER_OFFSET							2037 //	REAL
#define	MDATA_EXTRUDEINNER_ANGLE							2038 // REAL
#define	MDATA_EXTRUDEINNER_VARIANCE						2039 // REAL
#define MDATA_BEVEL_PRESERVEGROUPS						2040 //	BOOL
#define MDATA_BEVEL_OFFSET1										2041 // REAL
#define MDATA_BEVEL_OFFSET2										2042 // REAL
#define	MDATA_BEVEL_ANGLE											2043 // REAL
#define	MDATA_BEVEL_VARIANCE1									2044 // REAL
#define	MDATA_BEVEL_VARIANCE2									2045 // REAL
#define	MDATA_ARRAY_XCNT											2046 // LONG
#define	MDATA_ARRAY_YCNT											2047 // LONG
#define	MDATA_ARRAY_ZCNT											2048 // LONG
#define	MDATA_ARRAY_HOLES											2049 // REAL
#define	MDATA_ARRAY_OFFSET										2050 // VECTOR
#define MDATA_ARRAY_LOCALMOVE									2051 // VECTOR
#define MDATA_ARRAY_LOCALSCALE								2052 // VECTOR
#define MDATA_ARRAY_LOCALROTATE								2053 // VECTOR
#define MDATA_ARRAY_KEEPFORM									2054 // BOOL
#define	MDATA_CLONE_CNT												2055 // LONG
#define	MDATA_CLONE_HOLES											2056 // REAL
#define	MDATA_CLONE_AXIS											2057 // LONG
#define	MDATA_CLONE_OFFSET										2058 // REAL
#define	MDATA_CLONE_SCALE											2059 // REAL
#define	MDATA_CLONE_ROTATION									2060 // REAL
#define MDATA_CLONE_LOCALMOVE									2062 // VECTOR
#define MDATA_CLONE_LOCALSCALE								2063 // VECTOR
#define MDATA_CLONE_LOCALROTATE								2064 // VECTOR
#define MDATA_CLONE_KEEPFORM									2065 // BOOL
#define MDATA_BRIDGE_TRIANGULATE							2066 // BOOL
#define MDATA_MIRROR_SNAPPOINTS								2069 // BOOL
#define MDATA_MIRROR_DUPLICATE								2070 // BOOL
#define MDATA_MIRROR_WELD											2071 // BOOL
#define MDATA_MIRROR_TOLERANCE								2072 // REAL
#define MDATA_MIRROR_SYSTEM										2067 // LONG
#define MDATA_MIRROR_PLANE										2068 // LONG
#define MDATA_MIRROR_VALUE										2073 // REAL
#define MDATA_MIRROR_POINT										2074 // VECTOR
#define MDATA_MIRROR_VECTOR										2075 // VECTOR
#define MDATA_OPTIMIZE_TOLERANCE							2076 // REAL
#define MDATA_OPTIMIZE_POINTS									2077 // BOOL
#define MDATA_OPTIMIZE_POLYGONS								2078 // BOOL
#define MDATA_OPTIMIZE_UNUSEDPOINTS						2079 // BOOL
#define	MDATA_SPLINE_OUTLINESEPARATE					2080 // BOOL
#define MDATA_CREATEPOLYGON_KEEPQUADRANGLE		2081 // BOOL
#define MDATA_CROSSSECTION_ANGLE							2082 // REAL
#define MDATA_MATRIXEXTRUDE_STEPS							2083 // LONG
#define MDATA_MATRIXEXTRUDE_MOVE							2084 // VECTOR
#define MDATA_MATRIXEXTRUDE_SCALE							2085 // VECTOR
#define MDATA_MATRIXEXTRUDE_ROTATE						2086 // VECTOR
#define MDATA_MATRIXEXTRUDE_POLYGONCOORDS			2087 // BOOL
#define MDATA_MATRIXEXTRUDE_MOVEFROM					2088 // REAL
#define MDATA_MATRIXEXTRUDE_MOVETO						2089 // REAL
#define MDATA_MATRIXEXTRUDE_SCALEFROM					2090 // REAL
#define MDATA_MATRIXEXTRUDE_SCALETO						2091 // REAL
#define MDATA_MATRIXEXTRUDE_ROTATEFROM				2092 // REAL
#define MDATA_MATRIXEXTRUDE_ROTATETO					2093 // REAL
#define MDATA_MATRIXEXTRUDE_VARIANCE					2094 // LONG
#define MDATA_NORMALMOVE_VALUE								2095 // REAL
#define MDATA_NORMALSCALE_VALUE								2096 // REAL
#define MDATA_NORMALROTATE_VALUE							2097 // REAL
#define MDATA_SUBDIVIDE_HYPER									2098 // BOOL
#define MDATA_SUBDIVIDE_ANGLE									2099 // REAL
#define MDATA_SUBDIVIDE_SPLINESUB							2100 // LONG
#define MDATA_SUBDIVIDE_SUB										2101 // LONG
#define MDATA_SELECTFREE_TOLERANCE						2102 // BOOL
#define MDATA_SELECTFREE_VISIBLE							2103 // BOOL
#define MDATA_SELECTPOLY_TOLERANCE						2104 // BOOL
#define MDATA_SELECTPOLY_VISIBLE							2105 // BOOL
#define MDATA_SELECTRECT_TOLERANCE						2106 // BOOL
#define MDATA_SELECTRECT_VISIBLE							2107 // BOOL
#define MDATA_SELECTLIVE_VISIBLE							2108 // BOOL
#define MDATA_SELECTLIVE_RADIUS								2109 // LONG
#define MDATA_KNIFE_P1												2110 // VECTOR
#define MDATA_KNIFE_V1												2111 // VECTOR
#define MDATA_KNIFE_P2												2112 // VECTOR
#define MDATA_KNIFE_V2												2113 // VECTOR
#define MDATA_KNIFE_RESTRICT									2114 // BOOL
#define MDATA_KNIFE_ANGLE											2115 // REAL
#define MDATA_MAGNET_NEARESTPOINT							2116 // BOOL
#define MDATA_MAGNET_RADIUS										2117 // REAL
#define MDATA_MAGNET_WIDTH										2118 // REAL
#define MDATA_MAGNET_TYPE											2119 // LONG
#define MDATA_MIRROR_SELECTIONS								2120 // BOOL
#define MDATA_UNTRIANGULATE_ANGLE							2121 // BOOL
#define MDATA_MIRROR_ONPLANE									2122 // BOOL
#define MDATA_VERTEXPAINT_ENABLE							2123 // BOOL
#define MDATA_VERTEXPAINT_MODE								2124 // LONG
#define MDATA_VERTEXPAINT_STRENGTH						2125 // REAL
#define MDATA_CONVERTSELECTION_LEFT						2126 // LONG
#define MDATA_CONVERTSELECTION_RIGHT					2127 // LONG
#define MDATA_CONVERTSELECTION_TOLERANT				2128 // BOOL
#define MDATA_SDSWEIGHT_MODE									2129 // LONG
#define MDATA_SDSWEIGHT_STRENGTH							2130 // REAL
#define MDATA_SDSWEIGHT_INTERACTIVEMIN				2131 // REAL
#define MDATA_SDSWEIGHT_INTERACTIVEMAX				2132 // REAL
#define MDATA_EDGECUT_SUBDIV                  2133 // LONG
#define MDATA_EDGECUT_KEEPSEL                 2134 // BOOL
#define MDATA_EXTRUDE_EDGEBEVEL								2135 //	REAL
#define MDATA_EXTRUDE_EDGEANGLE								2136 //	REAL
#define MDATA_EXTRUDE_EDGESNAP								2137 // BOOL
#define MDATA_EXTRUDE_EDGESNAPVALUE						2138 // REAL
#define MDATA_EXTRUDE_KEEPSEL                 2139 // BOOL

#define MDATA_SETVERTEX_VALUE									4000 // REAL
#define MDATA_SETVERTEX_MODE									4001 // LONG

// send modeling command
enum
{
	MODIFY_ALL              = 0,
	MODIFY_POINTSELECTION   = 1,
	MODIFY_POLYGONSELECTION = 2,
	MODIFY_EDGESELECTION		= 3
};

// world preferences
#define WPREF_UNITS_BASIC										 10000 // LONG
#define WPREF_UNITS_TIME										 10001 // LONG
#define OBSOLETE_WPREF_UNITS_COLOR					 10002 // LONG
#define WPREF_UNITS_USEUNITS								 10003 // BOOL
#define WPREF_REFRESHTIME										 10004 // LONG
#define WPREF_RATIO_X												 10005 // REAL
#define WPREF_RATIO_Y												 10006 // REAL
#define WPREF_BACKGROUND_COL								 10007 // VECTOR
#define WPREF_FILMFORMAT_COL								 10008 // VECTOR
#define WPREF_HORIZON_COL										 10009 // VECTOR
#define WPREF_GRID_MAJOR_COL								 10010 // VECTOR
#define WPREF_GRID_MINOR_COL								 10011 // VECTOR
#define WPREF_SPLINESTART_COL								 10012 // VECTOR
#define WPREF_SPLINEEND_COL									 10013 // VECTOR
#define WPREF_CAMERA_COL										 10014 // VECTOR
#define WPREF_PARTICLE_COL									 10015 // VECTOR
#define WPREF_PMODIFIER_COL									 10016 // VECTOR
#define WPREF_BONE_COL											 10017 // VECTOR
#define WPREF_MODIFIER_COL									 10018 // VECTOR
#define WPREF_ACTIVEPOINT_COL								 10019 // VECTOR
#define WPREF_INACTIVEPOINT_COL							 10020 // VECTOR
#define WPREF_TANGENT_COL										 10021 // VECTOR
#define WPREF_ACTIVEPOLYGON_COL							 10022 // VECTOR
#define WPREF_INACTIVEPOLYGON_COL						 10023 // VECTOR
#define WPREF_TEXTURE_COL										 10024 // VECTOR
#define WPREF_TEXTUREAXIS_COL								 10025 // VECTOR
#define WPREF_ACTIVEBOX_COL									 10026 // VECTOR
#define WPREF_ANIMPATH_COL									 10027 // VECTOR
#define WPREF_XAXIS_COL											 10028 // VECTOR
#define WPREF_YAXIS_COL											 10029 // VECTOR
#define WPREF_ZAXIS_COL											 10030 // VECTOR
#define WPREF_WXAXIS_COL										 10031 // VECTOR
#define WPREF_WYAXIS_COL										 10032 // VECTOR
#define WPREF_WZAXIS_COL										 10033 // VECTOR
#define WPREF_SELECT_AXIS_COL								 10034 // VECTOR
#define WPREF_VERTEXSTART_COL								 10043 // VECTOR
#define WPREF_VERTEXEND_COL									 10044 // VECTOR
#define WPREF_UVMESH_GREYED_COL							 10045 // VECTOR
#define WPREF_UVMESH_ACTIVEPOLY_COL					 10046 // VECTOR
#define WPREF_UVMESH_INACTIVEAPOLY_COL			 10047 // VECTOR
#define WPREF_UVMESH_ACTIVEPOINT_COL				 10048 // VECTOR
#define WPREF_UVMESH_INACTIVEAPOINT_COL			 10049 // VECTOR
#define WPREF_NORMALS                        10050 // VECTOR

#define WPREF_HPB_SYSTEM											1001 // BOOL
#define WPREF_CENTER													1002 // BOOL
#define WPREF_BACKUP													1003 // BOOL
#define WPREF_RENDERMATS_EX										1004 // BOOL
#define WPREF_TABLET													1005 // BOOL
#define WPREF_SCALE_AXES											1006 // BOOL
#define WPREF_SEMI_TRANSPARENCY								1007 // BOOL
#define WPREF_OPENGL													1008 // BOOL
#define WPREF_LINK_SELECTION									1009 // BOOL
#define WPREF_ONLY_ACTIVEVIEW									1010 // BOOL
#define WPREF_SAVE_OPENGL											1012 // BOOL
#define WPREF_SAVE_PARTICLES									1013 // BOOL
#define WPREF_SAVE_LAYOUT											1014 // BOOL
#define WPREF_RENDER_SAFE											1015 // BOOL
#define WPREF_ACTION_SAFE											1016 // BOOL
#define WPREF_TITLE_SAFE											1017 // BOOL
#define WPREF_MAX_UNDOS												1018 // LONG
#define WPREF_MAX_LAST												1019 // LONG
#define WPREF_ACTION_FAC											1020 // REAL
#define WPREF_TITLE_FAC												1021 // REAL
#define WPREF_SEMI_FAC												1022 // REAL
#define WPREF_OPENGL_AA_LINES									1023 // BOOL
#define WPREF_OPENGL_PERSPECT									1024 // BOOL
#define WPREF_OPENGL_MIPMAP										1025 // BOOL
#define WPREF_USE_TEXTURES										1026 // BOOL
#define WPREF_OPENGL_FASTREDRAW								1027 // BOOL
#define WPREF_OPENGL_FASTLIVESELECTION				1028 // BOOL
#define WPREF_USE_QUICKTIME										1029 // BOOL
#define WPREF_TABLET_HIRES										1030 // BOOL
#define WPREF_3DGRID													1032 // Bool: draw grid lines as 3d?
#define WPREF_DRAWCACHE                       1033 // Bool: use draw cache
#define WPREF_OPENGL_POLYLINES                1034 // Bool: use polylines
#define WPREF_OPENGL_LIGHTING                 1035 // Bool: use opengl lighting
#define WPREF_OPENGL_DUALPLANES								1036 // Bool: allow dualplanes in glmode (gl extension)
#define WPREF_OPENGL_GLPOINTS									1037 // Bool: allow real gl points
#define WPREF_OPENGL_HIGHENDSHADING						1038 // Bool
#define WPREF_ONLY_ACTIVEVIEW_ANIMATION				1039 // Bool
#define WPREF_REALTIMESPINNER								  1040 // BOOL
#define WPREF_REALTIMEMANAGER									1042 // BOOL
#define WPREF_MAX_BACKUP											1043 // LONG
#define WPREF_CENTERAXIS											1044 // BOOL
#define WPREF_REWIND													1045 // BOOL
#define WPREF_CPUCOUNT												1046 // LONG
#define WPREF_OPENGL_DUALPLANES_ARB						1047 // Bool: use dualplane ARB extension
#define WPREF_DEFAULT_MATPREVIEWSIZE					1048 // LONG
#define WPREF_DESCRIPTIONLIMIT								1049 // LONG

#define WPREF_COLOR_SYSTEM_C4D								1100 // LONG
#define WPREF_COLOR_SYSTEM_BP									1101 // LONG
	#define COLORSYSTEM_HSVTAB						22
	#define COLORSYSTEM_TABLE							30
	#define COLORSYSTEM_RGB								10
	#define COLORSYSTEM_RGB_COLOR					11
	#define COLORSYSTEM_HSV								20
	#define COLORSYSTEM_HSV_COLOR					21
#define WPREF_COLOR_RGBRANGE									1102 // LONG
#define WPREF_COLOR_HRANGE										1103 // LONG
#define WPREF_COLOR_SVRANGE										1104 // LONG
	#define COLORSYSTEM_RANGE_PERCENT			0
	#define COLORSYSTEM_RANGE_DEGREE			3
	#define COLORSYSTEM_RANGE_255					1
	#define COLORSYSTEM_RANGE_65535				2
#define WPREF_COLOR_QUICK_C4D									1105
#define WPREF_COLOR_QUICK_BP									1106
#define WPREF_COLOR_MIX_C4D										1107
#define WPREF_COLOR_MIX_BP										1108

#define WPREF_COLOR_QUICKPRESET								1200 // Vector
#define WPREF_COLOR_QUICKPRESET_LAST					1299 // Vector
#define WPREF_COLOR_MIXING_1									1301 // Vector
#define WPREF_COLOR_MIXING_2									1302 // Vector
#define WPREF_COLOR_MIXING_3									1303 // Vector
#define WPREF_COLOR_MIXING_4									1304 // Vector

#define WPREF_BUBBLEHELP1										 21001
#define WPREF_BUBBLEHELP2										 21002
#define WPREF_THREADPRIORITY								 21003
#define WPREF_MENUICON											 21004
#define WPREF_MENUSHORTCUT									 21005
#define WPREF_INACTIVEBORDER								 21006
#define WPREF_ACTIVEBORDER									 21007
#define WPREF_DIALOGSTYLE										 21008
#define WPREF_DIALOGALIGN										 21009
#define WPREF_DELAY_MENU										 21010
#define WPREF_DELAY_MENUSCROLL							 21011
#define WPREF_DELAY_CMDPOPUP								 21012
#define WPREF_DELAY_DRAGSCROLL							 21013
#define WPREF_DELAY_SCROLLER1								 21014
#define WPREF_DELAY_SCROLLER2								 21015
#define WPREF_DELAY_TABSWITCH								 21016
#define WPREF_PATTERN_TIMESLIDER						 21040
#define WPREF_PATTERN_BG										 21041
#define WPREF_PATTERN_BGEDIT								 21042
#define WPREF_PATTERN_BGGADGET							 21043
#define WPREF_PATTERN_BGFOCUS								 21044
#define WPREF_PATTERN_DBARBG1								 21045
#define WPREF_PATTERN_DBARBG2								 21046
#define WPREF_FONT_STANDARD									 21050
#define WPREF_FONT_MONO											 21051
#define WPREF_PATTERN_USE										 21060
//#define WPREF_NAVSERVICE									 21061
#define WPREF_MAC_EXCHNGCTRLCMD							 21062
//#define WPREF_MAC_HIDEMENU								 21063
#define WPREF_MAC_ALLOWSTOPSLEEP						 21064 // Bool: deny mac power cycling
#define WPREF_UV_RELAX_DATA					         21065 // BaseContainer
#define WPREF_UV_OPTIMAL_MAPPING_DATA	       21066 // BaseContainer
#define WPREF_UV_PROJECTION_DATA	           21067 // BaseContainer
#define WPREF_UV_TAB_SEL    	               21068 // BaseContainer
#define WPREF_UV_TRANSFORM_DATA              21069 // BaseContainer

// mouse cursors
#define MOUSE_HIDE								 0
#define MOUSE_SHOW							 	 1
#define MOUSE_NORMAL							 2
#define MOUSE_BUSY								 3
#define MOUSE_CROSS								 4
#define MOUSE_QUESTION						 5
#define MOUSE_ZOOM_IN							 6
#define MOUSE_ZOOM_OUT						 7
#define MOUSE_FORBIDDEN						 8
#define MOUSE_DELETE							 9
#define MOUSE_COPY								10
#define MOUSE_INSERTCOPY					11
#define MOUSE_INSERTCOPYDOWN			12
#define MOUSE_MOVE								13
#define MOUSE_INSERTMOVE					14
#define MOUSE_INSERTMOVEDOWN			15
#define MOUSE_ARROW_H							16
#define MOUSE_ARROW_V							17
#define MOUSE_ARROW_HV						18
#define MOUSE_POINT_HAND					19
#define MOUSE_MOVE_HAND						20
#define MOUSE_IBEAM								21

// global events
#define EVMSG_CHANGE								604
#define EVMSG_DOCUMENTRECALCULATED	'drcl' // view has been animated, expression are executed, some manager data may have changed
#define	EVMSG_TOOLCHANGED						0xfff36465
#define	EVMSG_GRAPHVIEWCHANGED			400008000
#define EVMSG_AUTKEYMODECHANGED			200000009

#define EVMSG_TIMELINESELECTION			-1001
#define EVMSG_BROWSERCHANGE					-1002
#define EVMSG_MATERIALSELECTION			-1009
#define EVMSG_FCURVECHANGE					-1010

#define EVMSG_RAYTRACER_FINISHED    -1003
#define EVMSG_FRAME_SCENE           -1005
#define EVMSG_MATERIALPREVIEW				-1008
#define EVMSG_ACTIVEVIEWCHANGED			'acvw'
#define EVMSG_ASYNCEDITORMOVE		    'edmv'
		#define MOVE_START			0
		#define MOVE_CONTINUE		1
		#define MOVE_END				2 // -> par2 == ESC
#define	EVMSG_TIMECHANGED						'tchg'

#define EVENT_FORCEREDRAW				(1<<0)
#define EVENT_ANIMATE						(1<<1)
#define EVENT_NOEXPRESSION			(1<<2)
#define EVENT_GLHACK						(1<<3)
#define EVENT_CAMERAEXPRESSION	(1<<4)

// draw flags
#define DA_NO_THREAD						(1<<1)
#define DA_NO_REDUCTION					(1<<2)
#define DA_NO_ANIMATION					(1<<8)
#define DA_ONLY_ACTIVE_VIEW			(1<<10)
#define DA_NO_EXPRESSIONS				(1<<12)
#define DA_INDRAG								(1<<13)
#define DA_CAMERAEXPRESSION			(1<<16)

// animate scene/object flags
#define ANIMATE_NO_PARTICLES		(1<<2)
#define ANIMATE_QUICK						(1<<3)
#define ANIMATE_NO_CHILDS				(1<<6)

// undo types
#define UNDO_CHANGE							40
#define UNDO_CHANGE_NOCHILDS		41
#define UNDO_CHANGE_SMALL				42
#define UNDO_CHANGE_SELECTION		43
																
#define UNDO_NEW								44
#define UNDO_DELETE							45
																
#define UNDO_ACTIVATE						46
#define UNDO_DEACTIVATE					47
#define UNDO_TLACTIVATE					48
#define UNDO_TLDEACTIVATE				49

// handle types
#define HANDLE_MINI				0
#define HANDLE_SMALL			1
#define HANDLE_MIDDLE			2
#define HANDLE_BIG				3

// colors
#define COLOR_BACKGROUND			 0
#define COLOR_FILMFORMAT			 1
#define COLOR_HORIZON					 2
#define COLOR_GRID_MAJOR			 3
#define COLOR_GRID_MINOR			 4
#define COLOR_SPLINESTART			 5
#define COLOR_SPLINEEND				 6
#define COLOR_CAMERA					 7
#define COLOR_PARTICLE				 8
#define COLOR_PMODIFIER				 9
#define COLOR_BONE						10
#define COLOR_MODIFIER				11
#define COLOR_ACTIVEPOINT			12
#define COLOR_INACTIVEPOINT		13
#define COLOR_TANGENT					14
#define COLOR_ACTIVEPOLYGON		15
#define COLOR_INACTIVEPOLYGON 16
#define COLOR_TEXTURE					17
#define COLOR_TEXTUREAXIS			18
#define COLOR_ACTIVEBOX				19
#define COLOR_ANIMPATH				20
#define COLOR_XAXIS						21
#define COLOR_YAXIS						22
#define COLOR_ZAXIS						23
#define COLOR_WXAXIS					24
#define COLOR_WYAXIS					25
#define COLOR_WZAXIS					26
#define COLOR_SELECT_AXIS			27
#define COLOR_LAYER0					28
#define COLOR_LAYER1					29
#define COLOR_LAYER2					30
#define COLOR_LAYER3					31
#define COLOR_LAYER4					32
#define COLOR_LAYER5					33
#define COLOR_LAYER6					34
#define COLOR_LAYER7					35
#define COLOR_VERTEXSTART			36
#define COLOR_VERTEXEND				37

// dirty flags
#define DIRTY_MATRIX						(1<<1)
#define DIRTY_DATA							(1<<2)

// vflags
#define VFLAG_INTERNALRENDERER	(1<<1)
#define VFLAG_EXTERNALRENDERER	(1<<2)
#define VFLAG_ISOPARM						(1<<3)
#define VFLAG_POLYGONAL				  (1<<4)

// hierarchy clone flags
#define HCLONE_ASIS							(1<<0)
#define HCLONE_ASPOLY						(1<<1)
#define HCLONE_ASLINE						(1<<2)
#define HCLONE_ASSPLINE					(1<<3)

// error string dialog
#define IS_NOTHING			0
#define IS_DEGREE				1
#define IS_PERCENT			2
#define IS_METER				3
#define IS_LONG					5

#define Greater					0
#define GreaterOrEqual	1
#define Less						2
#define LessOrEqual			3
#define Between					4
#define BetweenOrEqual	5
#define BetweenOrEqualX	6
#define BetweenOrEqualY	7
#define Different				8

// paintmesh bits
#define PAINTMESH_QUAD   (1<<1) // polygon is quadrangle
#define PAINTMESH_SEL    (1<<6) // polygon selected

// im-/export formats
#define FORMAT_PREF				1000
#define FORMAT_WAV				1018
#define FORMAT_FCV				1019
#define FORMAT_L4D				1020
#define FORMAT_C4D_6_XML	1021
#define FORMAT_P4D				1022

#define FORMAT_C4DIMPORT		1001025
#define FORMAT_C4DEXPORT		1001026
#define FORMAT_XMLIMPORT		1001027
#define FORMAT_XMLEXPORT		1001028						
#define FORMAT_C4D4IMPORT		1001029
#define FORMAT_C4D5IMPORT		1001030
#define FORMAT_VRML1IMPORT	1001031
#define FORMAT_VRML1EXPORT	1001032
#define FORMAT_VRML2IMPORT	1001033
#define FORMAT_VRML2EXPORT	1001034
#define FORMAT_DXFIMPORT		1001035
#define FORMAT_DXFEXPORT		1001036
#define FORMAT_3DSIMPORT		1001037
#define FORMAT_3DSEXPORT		1001038
#define FORMAT_OBJIMPORT		1001039
#define FORMAT_OBJEXPORT		1001040
#define FORMAT_Q3DIMPORT		1001041
#define FORMAT_Q3DEXPORT		1001042
#define FORMAT_LWSIMPORT		1001043
#define FORMAT_LWOIMPORT		1001044
#define FORMAT_AIIMPORT			1001045
#define FORMAT_DEMIMPORT		1001046
#define FORMAT_D3DEXPORT		1001047

// registry
#define RE_WINDOW						   1
#define RE_OBJECT						   3
#define RE_TRACK						   4
#define	RE_SEQUENCE					   5
#define RE_KEY							   6
#define RE_TAG							   7
#define RE_MATERIAL					   8
#define RE_SHADER2D					   9
#define RE_SHADER3D					  10
#define RE_COFFEE_EXT				  11
#define RE_IO_IMAGE						12
#define RE_IO_MOVIE		        13
#define RE_IO_SCENE		        14
#define RE_IO_PREF	         	15
#define RE_IO_CATALOG         17
#define RE_IO_SOUND           18
#define RE_IO_IMAGESAVER			19
#define RE_IO_FCV							20
#define RE_IO_LAYOUT          21
#define RE_BITMAP_FILTER			22
#define RE_VIDEOPOST					23
#define RE_SCENEHOOK					24
#define RE_NODE								25
#define RE_DESCRIPTION				27
#define RE_LIBRARY						28
#define RE_CUSTOMDATATYPE			29
#define RE_RESOURCEDATATYPE		30

#define RE_PAINTER						50

class BaseBitmap;

struct IconData
{
	BaseBitmap	*bmp;
	LONG				x,y,w,h;
};

#endif
